/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	pgpMemLock9x.h - Win 95/98 memory locking functions header file


	$Id: pgpMemLock9x.h,v 1.2 2000/02/01 17:55:45 pbj Exp $
____________________________________________________________________________*/

#ifndef _pgpMemLock9x_h
#define _pgpMemLock9x_h

// constants
//	number of list items that can be held in each internal heap block
#define NUMITEMSPERBLOCK	64

// virtual memory paging in Win32 uses 4K byte pages (2^12)
#define WIN32PAGESIZE		12

// typedefs
//	elements of list used to keep track of locked blocks
typedef struct _MEMLOCKITEM {
	struct _MEMLOCKITEM*	pitemNext;
	HANDLE					hProcess;
	DWORD					dwHandle;
	ULONG					ulPage;
	ULONG					ulNumPages;
} PGPMEMLOCKITEM, *PPGPMEMLOCKITEM;

// block of such items
typedef struct _MEMLOCKBLOCK {
	struct _MEMLOCKBLOCK*	pblockNext;
	PGPMEMLOCKITEM			item[NUMITEMSPERBLOCK];
} PGPMEMLOCKBLOCK, *PPGPMEMLOCKBLOCK;

// structure to hold all memlock data
typedef struct {
	PPGPMEMLOCKBLOCK		pblockHeap;
	PPGPMEMLOCKITEM			pitemFreeList;
	PPGPMEMLOCKITEM			pitemLockedList;
} PGPMEMLOCK, *PPGPMEMLOCK;

// macros
//	PGPdbgPrint prints a message to the debugging console
#ifndef PGPdbgPrint
#if PGP_DEBUG
#define PGPdbgPrint(arg) Debug_Printf arg
#else
#define PGPdbgPrint(arg)
#endif

#if PGP_DEBUG && PGP_DEBUG_VERBOSE
#define PGPdbgVerbosePrint(arg)  Debug_Printf arg
#else
#define PGPdbgVerbosePrint(arg)
#endif
#endif


// prototypes
ULONG
pgpMemlockInit (
    PPGPMEMLOCK		ppml);

VOID
pgpMemlockCleanup (
    PPGPMEMLOCK		ppml,
	PVOID			pCriticalSection);

VOID
pgpMemlockCleanupHandle (
    PPGPMEMLOCK		ppml,
	DWORD			dwHandle,
	PVOID			pCriticalSection);

VOID
pgpMemlockProcessOperation (
	PPGPMEMLOCK			ppml,
    PPGPMEMLOCKSTRUCT	ppmls,
	DWORD				dwHandle,
	ULONG				ulStatusFlags,
	PVOID				pCriticalSection);
#endif //_pgpMemLock9x_h
